﻿var mediaUpload = {
    uploaderContainer: null,
    submitButton: null,
    cancelButton: null,
    areaName: null,
    controllerName: null,
    isExternalSource: false,

    initMediaUploadControls: function () {
        var self = this;
        var fileControl = self.uploaderContainer.find(".v-file input");

        this.submitButton.on("click", function () {
            if (a4.validateRequiredFields(self.uploaderContainer)) {
                var confirmButton = $(this);
                var nameInput = self.uploaderContainer.find("#Name");
                var descriptionInput = self.uploaderContainer.find("#Description");
                var locationRadio = $('input[name=Location]:checked', this.uploaderContainer);
                var externalUrlInput = self.uploaderContainer.find(".v-externalUrl input");
                var categoryIdInput = self.uploaderContainer.find("#CategoryId");
                var mediaTypeIdInput = self.uploaderContainer.find("#MediaTypeId");
                var fileIdInput = self.uploaderContainer.find("#FileId");
                var uploadForm = $("#v-uploadForm");
                var AddAndNew = confirmButton.hasClass("addAndNew");

                if(AddAndNew) {
                    $(".v-addNew").val("true");
                }

                if (!nameInput.val()) {
                    a4.showErrorMessage(languageResources.NameRequired);
                    return false;
                }

                if (categoryIdInput.val() == 0) {
                    a4.showErrorMessage(languageResources.CategoryRequired);
                    return false;
                }

                if (mediaTypeIdInput.val() == 0) {
                    a4.showErrorMessage(languageResources.MediaTypeRequired);
                    return false;
                }

                if (locationRadio.val() == "Local") {

                    if (!fileControl.val() && fileIdInput.val() == 0) {
                        a4.showErrorMessage(languageResources.FileRequired);
                        return false;
                    }
                }
                else {

                    if (!externalUrlInput.val()) {
                        a4.showErrorMessage(languageResources.UrlRequired);
                        return false;
                    }
                }

                var action = (mediaUpload.isExternalSource) ? "VerifyExternalFileNameIdExists" : "VerifyFileNameIdExists";
                var uploadAction = (mediaUpload.isExternalSource) ? "UpdateExternalMedia" : "UpdateMedia";

                a4.callServerMethod(a4.getAction(action, "Shared"), { "fileName": nameInput.val() },
                    function (result) {
                        a4.appendAntiForgeryToken(uploadForm);

                        if (result == 0) {
                            uploadForm.trigger("submit");
                        } else {

                            if (fileIdInput.val() == 0) {
                                modalDialog.showConfirmDialog(confirmOverwriteResources, function () {
                                    uploadForm.attr("action", a4.getAction(uploadAction, mediaUpload.controllerName, mediaUpload.areaName));
                                    fileIdInput.val(result);
                                    uploadForm.trigger("submit");
                                }, 250, 500, true);

                            }
                            else if (result != fileIdInput.val()) {
                                modalDialog.showConfirmDialog(itemExistsResources, function () {
                                    $("#OverwriteExistingFile", mediaUpload.uploaderContainer).val("True");
                                    uploadForm.attr("action", a4.getAction(uploadAction, mediaUpload.controllerName, mediaUpload.areaName));
                                    //fileIdInput.val(result);
                                    uploadForm.trigger("submit");
                                }, 220, 500, false, null, { saveButtonText: itemExistsResources.ConfirmButton });
                            } else {
                                uploadForm.trigger("submit");
                            }
                        }
                    },
                    function () {}
                );
            }
        });

        $(".v-localFileRadio", this.uploaderContainer).on("click", function () {
            $(".v-externalUrl", this.uploaderContainer).hide();
            $(".v-file", this.uploaderContainer).show();
        });

        $(".v-externalUrlRadio", this.uploaderContainer).on("click", function () {
            $(".v-file", this.uploaderContainer).hide();
            $(".v-externalUrl", this.uploaderContainer).show();
        });

        $(".v-file", this.uploaderContainer).on("change", function () {
            var nameInput = self.uploaderContainer.find("#Name");

            if (nameInput.val().trim() == "") {
                nameInput.val($(this).val().replace("C:\\fakepath\\", "").replace(/\.[^/.]+$/, ""));
            }
        });

        $("#CategoryName").a4autocomplete({
            valueProperty: "Id",
            labelProperty: "Name",
            data: mediaSelector.imageCategories,
            altValueField: $("#CategoryId")
        });

        $("#MediaTypeName").a4autocomplete({
            valueProperty: "Value",
            labelProperty: "Label",
            data: MediaTypes,
            altValueField: $("#MediaTypeId")
        });
 
        if (!(typeof MaxRequestLength === "undefined") && MaxRequestLength > 0) {
            fileControl.on("change", function (e) {
                var files = e.originalEvent.target.files;
                var file = files[0];
                var fileSize = file.size / 1024; //converts bytes to KB

                if ((file.size / 1024) > MaxRequestLength) {
                    a4.showErrorMessage(resources.FileTooLarge);
                    fileControl.val("");
                }
            });
        }
    }
}